;	Copyright (C) 2000 Networks Associates Technology, Inc.
;	All rights reserved.
;	
;	pgpDriver.asm - assembly code for PGPutil driver
;
;	$Id: pgpDriver.asm,v 1.6 2001/03/12 21:23:37 pbj Exp $
;
		.386p

SEGNUM equ 1

;==================================
IFNDEF PGP_EROS
PGP_EROS	EQU		0
ENDIF

IF PGP_EROS
; this is the Eros version ...

		include vmm.inc

Declare_Virtual_Device PGPSDK, 0, 1, PGPSDK_control,\
		Undefined_Device_ID, Undefined_Init_Order

Begin_Control_Dispatch PGPSDK
		Control_Dispatch Sys_Dynamic_Device_Init, _OnDeviceInit, cCall
		Control_Dispatch Sys_Dynamic_Device_Exit, _OnSystemExitC, cCall
		Control_Dispatch W32_DeviceIOControl,     _OnDeviceIoControl, cCall, <esi>
End_Control_Dispatch   PGPSDK

;==================================
ELSE
; and this is the Full version ...

		include vmm.inc
		include vmd.inc
		include vkd.inc
		include local.inc

PGPutil_Inactivity	EQU	BEGIN_RESERVED_PRIVATE_SYSTEM_CONTROL +1

Declare_Virtual_Device PGPSDK, 0, 1, PGPSDK_control,\
		Undefined_Device_ID, VKD_INIT_ORDER+000010000H

Begin_Control_Dispatch PGPSDK
		Control_Dispatch Device_Init, _OnDeviceInit, cCall, <esi>
		Control_Dispatch W32_DeviceIOControl, _OnDeviceIoControl, cCall, <esi>
		Control_Dispatch Init_Complete, OnInitComplete
		Control_Dispatch System_Exit, _OnSystemExitC, cCall
		Control_Dispatch Sys_Dynamic_Device_Init, OnSysDynamicDeviceInit, cCall
		Control_Dispatch Sys_Dynamic_Device_Exit, OnSysDynamicDeviceExit, cCall
		Control_Dispatch PGPutil_Inactivity, _OnPGPutilInactivity, cCall, <esi>
End_Control_Dispatch   PGPSDK

MakeCDecl      IFSMgr_InstallFileSystemApiHook
MakeCDecl      IFSMgr_RemoveFileSystemApiHook
MakeCDecl      UniToBCSPath
MakeCDecl      _VWIN32_QueueUserApc
MakeCDecl      IFSMgr_Block
MakeCDecl      IFSMgr_Wakeup
MakeCDecl      _VolFlush

VxD_LOCKED_DATA_SEG
next_mouse	dd	0
next_kbd	dd	0
VxD_LOCKED_DATA_ENDS

;------------------------------------------------------------------------------

BeginProc OnInitComplete, locked
		GetVxDServiceOrdinal eax, VMD_Manipulate_Pointer_Message
		mov   	esi, offset32 MouseHookProc
		VMMCall	Hook_Device_Service
		jc		initfail

		GetVxDServiceOrdinal eax, VKD_Filter_Keyboard_Input
		mov		esi, offset32 KeyboardHookProc
		VMMCall Hook_Device_Service
		jc		initfail1

;		clc
		ret

initfail1:
		GetVxDServiceOrdinal eax, VMD_Manipulate_Pointer_Message
		mov		esi, offset32 MouseHookProc
		VMMCall Unhook_Device_Service

initfail:
		stc
		ret
EndProc OnInitComplete

;------------------------------------------------------------------------------

BeginProc OnSystemExit, CCALL, PUBLIC, locked
		GetVxDServiceOrdinal eax, VMD_Manipulate_Pointer_Message
		mov		esi, offset32 MouseHookProc
		VMMCall Unhook_Device_Service

		GetVxDServiceOrdinal eax, VKD_Filter_Keyboard_Input
		mov		esi, offset32 KeyboardHookProc
		VMMCall Unhook_Device_Service

;		clc
		ret
EndProc OnSystemExit

;------------------------------------------------------------------------------

BeginProc MouseHookProc, service, hook_proc, next_mouse, locked
		pushad
		push	ax					; button status
		extrn	_PGPMouseMoved:near
		call	_PGPMouseMoved		; call C function
		add		esp, 2				; lose args
		popad
		jmp		[next_mouse]
EndProc MouseHookProc

;------------------------------------------------------------------------------

BeginProc KeyboardHookProc, service, hook_proc, next_kbd, locked
		pushad
		push	cx					; scan code
		extrn	_PGPKBDEvent:near
		call	_PGPKBDEvent		; call C function
		add		esp, 2				; lose args
		popad		
		jmp		[next_kbd]
EndProc KeyboardHookProc

;------------------------------------------------------------------------------

BeginProc OnSysDynamicDeviceInit, locked
		cCall _OnDeviceInit, <esi>
		cmp eax, 0
		je abort

		call OnInitComplete
abort:
		ret
EndProc OnSysDynamicDeviceInit

;------------------------------------------------------------------------------

BeginProc OnSysDynamicDeviceExit, locked
		call OnSystemExit
		ret
EndProc OnSysDynamicDeviceExit

;==================================
ENDIF

		end
